#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>

int main(int argc, char **argv) {
    char *err;

    if (argc < 2 || argc > 3) {
        fprintf(stderr, "Usage: %s {successor_name} [do-it-right]\n",
            argv[0]);
        exit(EXIT_FAILURE);
    }
    /* Check for the successor file being there, with r.x permissions */
    if (access(argv[1], R_OK | X_OK) < 0) {
        if (errno == ENOENT)
            err = "is missing; please build it and retry.";
        else if (errno == EACCES)
            err =
                "does not have sufficient permissions to execute.";
        else
            err = ": [other error]";
        FATAL("Successor file \"%s\" %s\n", argv[1], err);
    }

    if (argc == 2) {    /* the wrong way */
        if (execl("./successor_setnm", argv[1], argv[1],
              (char *)0) == -1)
            perror("execl \"successor_setnm\" 1 failed\n");
    } else if (argc == 3) { /* the right way */
        if (execl("./successor_setnm", argv[2], argv[1],
              argv[2], (char *)0) == -1)
            perror("execl \"successor_setnm\" 2 failed\n");
    }
    exit(EXIT_SUCCESS);
}