#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/prctl.h>

int main(int argc, char **argv) {
    int i;

    if (argc < 2 || argc > 3) {
        fprintf(stderr, "Usage: %s {successor_name}"
                " [do-it-right-param]\n", argv[0]);
        exit(EXIT_FAILURE);
    }

    printf("%s:parameters received:\n", argv[0]);
    for (i=0; i<argc; i++)
        printf("argv[%d]=%s\n", i, argv[i]);

    if (argc == 3) { /* the "do-it-right" case! */
        printf("%s: setting name to \"%s\" via prctl(2)"
                " [Right]\n", argv[0], argv[2]);
        if (prctl(PR_SET_NAME, argv[2], 0, 0, 0) < 0)
            perror("prctl failed\n");
    } else {         /* wrong way... */
        printf("%s: attempt to implicitly set name to \"%s\""
            " via the argv[0] passed to execl [Wrong]\n",
            argv[0], argv[1]);
    }

    printf("%s: pausing now...\n", argv[0]);
    pause();

    exit (EXIT_SUCCESS);
}