#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>

#define CMD_MAXLEN   128

static int gVerbose = 0;
const char *PromptStr = ">> ";

static char *getcmd(char *cmdstr) {
    printf("%s", PromptStr);
    fflush(stdout);

    if (!fgets(cmdstr, CMD_MAXLEN - 1, stdin))
        return NULL;
    cmdstr[strlen(cmdstr) - 1] = '\0';

    return cmdstr;
}

static void run_dumbsh(void) {
    pid_t ret;
    char *cmd;

    cmd = calloc(CMD_MAXLEN, sizeof(char));
    if (!cmd)
        perror("calloc failed!\n");

    while (1) {
        if (!getcmd(cmd)) {
            free(cmd);
            perror("getcmd(): EOF or failed\n");
        }

        /* Stopping condition */
        if (!strncmp(cmd, "quit", 4))
            break;

        if (cmd[0] == 0)    /* user pressed [Enter] */
            continue;

        switch ((ret = fork())) {
        case -1:
            free(cmd);
            perror("fork failed, aborting!\n");
        case 0: /* Child */
            if (execlp(cmd, cmd, (char *)0) == -1) {
                WARN("child: execlp failed\n");
                free(cmd);
                exit(EXIT_FAILURE);
            }
            /* should never reach here */
            exit(EXIT_FAILURE); // just to avoid gcc warnings
        default: /* Parent */
            if (wait(0) < 0) 
                perror("wait failed, aborting..\n");
        } // switch
    } // while(1)
    free(cmd);
}

static inline void usage(char *name) {
    printf("Usage: %s [-v]|[--help]\n"
           " -v : verbose mode\n"
           " --help : display this help screen.\n", name);
}

int main(int argc, char **argv) {
    if (argc >= 2) {
        if (!strncmp(argv[1], "--help", 6)) {
            usage(argv[0]);
            exit(EXIT_SUCCESS);
        }
        if (!strncmp(argv[1], "-v", 2))
            gVerbose = 1;
    }

    run_dumbsh();
    exit(EXIT_SUCCESS);
}