#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>


#define DELAY_LOOP(val,loop_count) {                              \
    int c=0, m;                                                   \
    unsigned int for_index,inner_index;                           \
                                                                  \
    for(for_index=0;for_index<loop_count;for_index++) {           \
        beep((val));                                              \
        c++;                                                      \
        for(inner_index=0;inner_index<HZ*1000;inner_index++)      \
            for(m=0;m<30;m++);                                    \
        }                                                         \
    /*printf("c=%d\n",c);*/                                       \
}


int main(int argc, char **argv) {
    pid_t ret;

    if (argc != 3) {
        fprintf(stderr,
            "Usage: %s {child-numbytes-to-write} {parent-numbytes-to-write}\n",
            argv[0]);
        exit(EXIT_FAILURE);
    }
    /* We leave the validation of the two parameters as a small
     * exercise to you, dear reader :-)
     */

    switch ((ret = fork())) {
    case -1:
        FATAL("fork failed, aborting!\n");
    case 0:     /* Child */
        printf("Child process, PID %d:\n"
               " return %d from fork()\n", getpid(), ret);
        DELAY_LOOP('c', atoi(argv[1]));
        printf("Child process (%d) done, exiting ...\n", getpid());
        exit(EXIT_SUCCESS);
    default:        /* Parent */
        printf("Parent process, PID %d:\n"
               " return %d from fork()\n", getpid(), ret);
        DELAY_LOOP('p', atoi(argv[2]));
    }
    printf("Parent (%d) will exit now...\n", getpid());
    exit(EXIT_SUCCESS);
}