#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>

#define DEBUG
/* SIGCHLD handler */
static void child_dies(int signum) {
#ifdef DEBUG
    printf("\n*** Child dies! ***\n");
#endif
}

static void usage(char *name) {
    fprintf(stderr,
        "Usage: %s {option-to-prevent-zombies}\n"
        " 1 : (2.6 Linux) using the SA_NOCLDWAIT flag with sigaction(2)\n"
        " 2 : just ignore the signal SIGCHLD\n", name);
    exit(EXIT_FAILURE);
}

int main(int argc, char **argv) {
    struct sigaction act;
    int opt = 0;

    if (argc != 2)
        usage(argv[0]);

    opt = atoi(argv[1]);
    if (opt != 1 && opt != 2)
        usage(argv[0]);

    memset(&act, 0, sizeof(act));
    if (opt == 1) {
        act.sa_handler = child_dies;
        act.sa_flags = SA_NOCLDWAIT;
    }
    if (opt == 2)
        act.sa_handler = SIG_IGN;
    act.sa_flags |= SA_RESTART | SA_NOCLDSTOP; 
    /* no SIGCHLD on stop of child(ren) */

    if (sigaction(SIGCHLD, &act, 0) == -1)
        perror("sigaction failed");

    printf("parent: %d\n", getpid());
    switch (fork()) {
    case -1:
        perror("fork failed");
    case 0:     // Child
        printf("child: %d\n", getpid());
        DELAY_LOOP('c', 25);
        exit(0);
    default:        // Parent
        while (1)
            pause();
    }
    exit(0);
}

