#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <string.h>
#include <signal.h>

int show_blocked_signals(void) {
    sigset_t oldset;
    int i, none=1;

    /* sigprocmask: 
     * int sigprocmask(int how, const sigset_t *set, sigset_t *oldset);
     * if 'set' is NULL, the 'how' is ignored, but the
     * 'oldset' sigmask value is populated.
     */
    sigemptyset(&oldset);
    if (sigprocmask(SIG_UNBLOCK, 0, &oldset) < 0)
        return -1;
    printf("[SigBlk: ");
    for (i=1; i<=64; i++) {
        if (sigismember(&oldset, i)) {
            none=0;
            printf("%d ", i);
        }
    }
    printf("%s\n", none ? "-none-]" : "]");
    fflush(stdout);
    return 0;
}


/* Our simple signal handler */
static void my_handler(int signum) {
    const char *str1 = "*** my_handler: handled SIGINT ***\n";
    const char *str2 = "*** my_handler: handled SIGQUIT ***\n";

    if (show_blocked_signals() < 0)
        perror("sigprocmask -query- failed\n");

    switch (signum) {
    case SIGINT:
        if (write(STDOUT_FILENO, str1, strlen(str1)) < 0)
            perror("write str1 failed!");
        return;
    case SIGQUIT:
        if (write(STDOUT_FILENO, str2, strlen(str2)) < 0)
            perror("write str2 failed!");
        return;
    }
}

int main(void) {
    unsigned long int i = 1;
    struct sigaction act;

    /* Init sigaction:
     * setup 'my_handler' as the signal handler function,
     * trap just the SIGINT and SIGQUIT signals.
     */
    memset(&act, 0, sizeof(act));
    act.sa_handler = my_handler;
    /* This is interesting: we fill the signal mask, implying that
     * _all_ signals are masked (blocked) while the signal handler
     * runs! */
    sigfillset(&act.sa_mask);

    if (sigaction(SIGINT, &act, 0) < 0)
        perror("sigaction on SIGINT failed");
    if (sigaction(SIGQUIT, &act, 0) < 0)
        perror("sigaction on SIGQUIT failed");

    while (1) {
        printf("Looping, iteration #%02ld ...\n", i++);
        (void)sleep(1);
    }

    exit(EXIT_SUCCESS);
}