#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <string.h>
#include <signal.h>

/* Simple signal handler */
static void siggy(int signum) {
    const char *str1 = "*** siggy: handled SIGINT ***\n";
    const char *str2 = "*** siggy: handled SIGQUIT ***\n";

    switch (signum) {
    case SIGINT:
        if (write(STDOUT_FILENO, str1, strlen(str1)) < 0)
            printf("write str1 failed!\n");
        return;
    case SIGQUIT:
        if (write(STDOUT_FILENO, str2, strlen(str2)) < 0)
            printf("write str2 failed!\n");
        return;
    }
}

int main(void) {
    unsigned long int i = 1;
    struct sigaction act;

    /* Init sigaction to defaults via the memset,
     * setup 'siggy' as the signal handler function,
     * trap just the SIGINT and SIGQUIT signals.
     */
    memset(&act, 0, sizeof(act));
    act.sa_handler = siggy;
    if (sigaction(SIGINT, &act, 0) < 0)
        perror("sigaction on SIGINT failed");
    if (sigaction(SIGQUIT, &act, 0) < 0)
        perror("sigaction on SIGQUIT failed");

    while (1) {
        printf("Looping, iteration #%02ld ...\n", i++);
        (void)sleep(1);
    }

    exit(EXIT_SUCCESS);
}
