#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <string.h>
#include <sys/file.h>

#define MAX 10

#define DELAY_LOOP_SILENT(loop_count)                                          \
{                                                                              \
	int c=0, m;                                                            \
	unsigned int for_index,inner_index;                                    \
	                                                                       \
	for(for_index=0;for_index<loop_count;for_index++) {                    \
		c++;                                                           \
		for(inner_index=0;inner_index<HZ*1000;inner_index++)           \
			for(m=0;m<30;m++);                                     \
		}                                                              \
	/*printf("c=%d\n",c);*/                                                \
}

static volatile sig_atomic_t s=0, t=0;

/* 
 * stack(): return the current value of the stack pointer register.
 * The trick/hack: on x86 CPU's, the ABI tells us that the return
 * value is always in the accumulator (EAX/RAX); so we just initialize
 * it to the stack pointer (using inline assembly)!
 */
void *stack(void) {
    if (__WORDSIZE == 32) {
        __asm__("movl %esp, %eax");
    } else if (__WORDSIZE == 64) {
        __asm__("movq %rsp, %rax");
    }
/* Accumulator holds the return value */
}

#undef SHOW_MASKED
/*#define SHOW_MASKED*/
static void rt_sighdlr(int signum) {
#ifdef SHOW_MASKED
    if (show_blocked_signals() < 0)
        perror("sigprocmask -query- failed\n");

#endif
    fprintf(stderr, "\nsighdlr: signal %d,", signum);
    if ((signum == SIGRTMAX-5) ||
        (signum == SIGRTMIN+5) ||
        (signum == SIGRTMAX)) {
        s ++; t ++;
        if (s >= MAX)
            s = 1;
        fprintf(stderr, " s=%d ; total=%d; stack %p :", s, t, stack());
        //DELAY_LOOP('o', 8);
        DELAY_LOOP_SILENT(8);
        fprintf(stderr, "*");
    }
}

int main(void) {
    struct sigaction act;

    printf("Trapping the three realtime signals\n");
    memset(&act, 0, sizeof(act));
    act.sa_handler = rt_sighdlr;
    act.sa_flags = SA_RESTART;
    /* Set sigmask to all 1's, thus masking all signals
       while this handler runs */
    sigfillset(&act.sa_mask);

    if (sigaction(SIGRTMAX-5, &act, 0) == -1)
        perror("sigaction %s failed\n", "SIGRTMAX-5");
    if (sigaction(SIGRTMIN+5, &act, 0) == -1)
        perror("sigaction %s failed\n", "SIGRTMIN+5");
    if (sigaction(SIGRTMAX, &act, 0) == -1)
        perror("sigaction %s failed\n", "SIGRTMAX");

    printf("Process awaiting signals ...\n");
    while (1)
        (void)pause();
    exit(EXIT_SUCCESS);
}