#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <time.h>
#include <signal.h>
#include <string.h>
#include <errno.h>

static void sig_handler(int signum) {
    fprintf(stderr, "**Signal %d interruption!**\n", signum);
}

int main(int argc, char **argv) {
    struct sigaction act;
    int nsec = 10, ret;
    struct timespec req, rem;

    if (argc == 1) {
        fprintf(stderr, "Usage: %s option=[0|1]\n"
            "0 : uses the sleep(3) function\n"
            "1 : uses the nanosleep(2) syscall\n", argv[0]);
        exit(EXIT_FAILURE);
    }

    /* setup signals: trap SIGINT and SIGQUIT */
    memset(&act, 0, sizeof(act));
    act.sa_handler = sig_handler;
    sigemptyset(&act.sa_mask);
    act.sa_flags = SA_RESTART;
    if (sigaction(SIGINT, &act, 0) || sigaction(SIGQUIT, &act, 0))
        perror("sigaction failure\n");

    if (atoi(argv[1]) == 0) {   /* sleep */
        printf("sleep for %d s now...\n", nsec);
        ret = sleep(nsec);
        printf("sleep returned %u\n", ret);
    } else if (atoi(argv[1]) == 1) {    /* nanosleep */
        req.tv_sec = nsec;
        req.tv_nsec = 0;
        while ((nanosleep(&req, &rem) == -1) && (errno == EINTR)) {
            printf("nanosleep interrupted: rem time: %07lu.%07lu\n",
                   rem.tv_sec, rem.tv_nsec);
            req = rem;
        }
    }
    exit(EXIT_SUCCESS);
}

