#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include <unistd.h>

/* Simple signal handler */
static void sig_handler(int signum) {
    const char *str = "   *** Timeout! [SIGALRM received] ***\n";

    if (signum != SIGALRM)
        return;
    if (write(STDOUT_FILENO, str, strlen(str)) < 0)
        perror("write str failed!");
}

int main(int argc, char **argv)
{
    int n = 0;
    struct sigaction act;

    if (argc != 2) {
        fprintf(stderr, "Usage: %s seconds-to-timeout(>0)\n", argv[0]);
        exit(EXIT_FAILURE);
    }
    n = atoi(argv[1]);
    if (n <= 0) {
        fprintf(stderr, "Usage: %s seconds-to-timeout(>0)\n", argv[0]);
        exit(EXIT_FAILURE);
    }

    memset(&act, 0, sizeof(act));
    act.sa_handler = sig_handler;
    if (sigaction(SIGALRM, &act, 0) < 0)
        perror("sigaction on SIGALRM failed");

    alarm(n);
    printf("A timeout for %ds has been armed...\n", n);
    pause();        /* wait for the signal ... */

    exit(EXIT_SUCCESS);
}