#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include <unistd.h>

/* Simple signal handler */
static void sig_handler(int signum) {
    const char *str = "   *** Timeout! [SIGALRM received] ***\n";

    if (signum != SIGALRM)
        return;
    if (write(STDOUT_FILENO, str, strlen(str)) < 0)
        WARN("write str failed!");
}

int main(int argc, char **argv)
{
    int n = 0;
    struct sigaction act;

    if (argc != 2) {
        fprintf(stderr, "Usage: %s seconds-to-repetitive-timeout(>0)\n",
            argv[0]);
        exit(EXIT_FAILURE);
    }
    n = atoi(argv[1]);
    if (n <= 0) {
        fprintf(stderr, "Usage: %s seconds-to-repetitive-timeout(>0)\n",
            argv[0]);
        exit(EXIT_FAILURE);
    }

    memset(&act, 0, sizeof(act));
    act.sa_handler = sig_handler;
    if (sigaction(SIGALRM, &act, 0) < 0)
        FATAL("sigaction on SIGALRM failed");

    alarm(n);
    printf("A timeout for %ds has been armed...\n", n);
    /* (Manually) re-invoke the alarm every 'n' seconds */
    while (1) {
        pause();    /* wait for the signal ... */
        alarm(n);
        printf(" Timeout for %ds has been (re)armed...\n", n);
    }

    exit(EXIT_SUCCESS);
}
