#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include <sys/time.h>
#include <errno.h>

static volatile sig_atomic_t opt;

static void ticktock(int signum) {
    char tmstamp[128];
    struct timespec tm;
    int myerrno = errno;

    if (clock_gettime(CLOCK_REALTIME, &tm) < 0)
        perror("clock_gettime failed\n");
    if (ctime_r(&tm.tv_sec, &tmstamp[0]) == NULL)
        perror("ctime_r failed\n");

    if (opt == 0) {
        if (write(STDOUT_FILENO, tmstamp, strlen(tmstamp)) < 0)
            perror("write failed\n");
    } else if (opt == 1) {
        tmstamp[strlen(tmstamp) - 1] = '\0';
        printf("\r%s", tmstamp);
        fflush(stdout);
    }
    errno = myerrno;
}

static void usage_die(char *name) {
    fprintf(stderr, "Usage: %s {0|1}\n"
        " 0 : the Correct way (using write(2) in the signal handler)\n"
        " 1 : the *Wrong* way (using printf(3) in the signal handler) *@your risk*\n",
        name);
    exit(EXIT_FAILURE);
}

int main(int argc, char **argv) {
    struct sigaction act;
    struct itimerval mytimer;

    if ((argc != 2) || (strlen(argv[1]) != 1))
        usage_die(argv[0]);
    opt = atoi(argv[1]);
    if ((opt != 0) && (opt != 1))
        usage_die(argv[0]);

    printf("Initializing ...\n");
    if (opt == 1)
        printf(" *WARNING* [Using printf in signal handler]\n");

    memset(&act, 0, sizeof(act));
    act.sa_handler = ticktock;
    sigfillset(&act.sa_mask);   /* disallow all signals while handling */
    if (sigaction(SIGALRM, &act, 0) < 0)
        perror("sigaction on SIGALRM failed");

    /* Setup a single second (repeating) interval timer */
    memset(&mytimer, 0, sizeof(struct itimerval));
    mytimer.it_value.tv_sec = 1;
    mytimer.it_interval.tv_sec = 1;
    if (setitimer(ITIMER_REAL, &mytimer, 0) < 0)
        perror("setitimer failed\n");

    while (1)
        (void)pause();

    exit(EXIT_SUCCESS);
}