#!/bin/bash
name=$(basename $0)
SEP="------------------------------------------------------------------"
declare -a gDirArr=('/bin' '/usr/bin' '/sbin' '/usr/sbin' '/usr/local/bin' '/usr/local/sbin');

scanforcaps() {
[ ! -d $1 ] && return 1
for fname in /$1/*
do
  getcap ${fname}
done
}

show_files_with_caps() {
 echo "Scanning various folders for binaries with (modern) 'capabilities' embedded ..."
 echo "${SEP}"
 for ((i=0; i<${#gDirArr[@]}; i++))
 do
    dir=${gDirArr[${i}]}
    printf "[+] Scanning %-15s ...\n" "${dir}"
    scanforcaps ${dir}
 done
}

sysinfo() {
echo "${SEP}"
echo "System Information (LSB):"
echo "${SEP}"
lsb_release -a
echo -n "kernel: "
uname -r
echo "${SEP}"
}

sysinfo
show_files_with_caps
exit 0

