import time

class Timer:
    def __init__(self, timeout):
        self.timeout = timeout
        self.start = time.time()

    def done(self):
        return time.time() - self.start > self.timeout

    def on_timer_done(self, callback):
        self.callback = callback
        timer = Timer(1.0)

timer = Timer(1.0)
timer.on_timer_done(lambda: print("Timer is done!"))
while True:
    if timer.done():
        timer.callback()
        break


