#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <pthread.h>

#define NTHREADS    2

/* 
 * DELAY_LOOP macro
 * @val        : ASCII value to print
 * @loop_count : times to loop around
 */
#define HZ  250
#define DELAY_LOOP(val,loop_count)                                             \
{                                                                              \
    int c=0, m;                                                            \
    unsigned int for_index,inner_index;                                    \
                                                                           \
    for(for_index=0;for_index<loop_count;for_index++) {                    \
        beep((val));                                                   \
        c++;                                                           \
        for(inner_index=0;inner_index<HZ*1000;inner_index++)           \
            for(m=0;m<30;m++);                                     \
        }                                                              \
    /*printf("c=%d\n",c);*/                                                \
}
#define DELAY_LOOP_SILENT(loop_count)                                          \
{                                                                              \
    int c=0, m;                                                            \
    unsigned int for_index,inner_index;                                    \
                                                                           \
    for(for_index=0;for_index<loop_count;for_index++) {                    \
        c++;                                                           \
        for(inner_index=0;inner_index<HZ*1000;inner_index++)           \
            for(m=0;m<30;m++);                                     \
        }                                                              \
    /*printf("c=%d\n",c);*/                                                \
}

/*--------------- Mutex Lock and Unlock ----------------------------------*/
#define LOCK_MTX(mtx) do {                                       \
    int ret=0;                                               \
    if ((ret = pthread_mutex_lock(mtx)))                     \
        fprintf(stderr, "pthread_mutex_lock failed! [%d]\n", ret); \
} while(0)

#define UNLOCK_MTX(mtx) do {                                       \
    int ret=0;                                                 \
    if ((ret = pthread_mutex_unlock(mtx)))                     \
        fprintf(stderr, "pthread_mutex_unlock failed! [%d]\n", ret); \
} while(0)

static int gWorkDone=0;
/* The {cv,mutex} pair */
static pthread_cond_t mycv;
static pthread_mutex_t mycv_mutex = PTHREAD_MUTEX_INITIALIZER;

/* Thread B: we perform the 'work', and then 'signal' thread A via the
 * {CV, mutex} pair that we are done.
 */
static void * workerB(void *msg) {
    int ret=0;

    printf(" [thread B] : perform the 'work' now (first sleep(1) :-)) ...\n");
    sleep(1);
    DELAY_LOOP('b', 72);

    printf("\n [thread B] : work done, signal thread A to continue ...\n");
    /* It's not strictly required to lock/unlock the associated mutex
     * while signalling; we do it here to be pedantically correct (and
     * to shut helgrind up).
     */
    LOCK_MTX(&mycv_mutex);
    gWorkDone = 1;
    ret = pthread_cond_signal(&mycv);
    if (ret)
        fprintf(stderr, "pthread_cond_signal() in thread B failed! [%d]\n", ret);
    UNLOCK_MTX(&mycv_mutex);
    pthread_exit((void *)0);
}

/* Thread A must wait until thread B completes the 'work';
 * we use a {CV, mutex} pair to easily and efficiently achieve
 * this.
 */
static void * workerA(void *msg) {
    int ret=0;

    LOCK_MTX(&mycv_mutex);
    while (1) {
        printf(" [thread A] : now waiting on the CV for thread B to finish...\n");
        ret = pthread_cond_wait(&mycv, &mycv_mutex);
        // Blocking: associated mutex auto-released ...
        if (ret)
            fprintf(stderr, "pthread_cond_wait() in thread A failed! [%d]\n", ret);
        // Unblocked: associated mutex auto-acquired upon release from the condition wait...
        
        printf(" [thread A] : recheck the predicate (is the work really "
            "done or is it a spurious wakeup?)\n");
        if (gWorkDone)
            break;
        printf(" [thread A] : SPURIOUS WAKEUP detected !!! "
            "(going back to CV waiting)\n");
    }
    UNLOCK_MTX(&mycv_mutex);
    printf(" [thread A] : (cv wait done) thread B has completed it's work...\n");
    pthread_exit((void *)0);
}

int main(void) {
    long i;
    int ret, stat=0;
    pthread_t tid[NTHREADS];
    pthread_attr_t attr;
    pthread_condattr_t cvattr;

    // Init the thread attribute structure to defaults
    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_JOINABLE);

    // Init a condition variable attribute object
    if ((ret = pthread_condattr_init(&cvattr)))
        fprintf(stderr, "pthread_condattr_init failed [%d].\n", ret);
    // Init a {cv,mutex} pair: condition variable & it's associated mutex
    if ((ret = pthread_cond_init(&mycv, &cvattr)))
        fprintf(stderr, "pthread_cond_init failed [%d].\n", ret);
    //  the mutex lock has been statically initialized above.

    // Create the worker - A and B - threads
    ret = pthread_create(&tid[0], &attr, workerA, (void *)0);
    if (ret)
        fprintf(stderr, "pthread_create() thread A failed! [%d]\n", ret);
    ret = pthread_create(&tid[1], &attr, workerB, (void *)0);
    if (ret)
        fprintf(stderr, "pthread_create() thread B failed! [%d]\n", ret);
    pthread_attr_destroy(&attr);

    // Thread join loop
    for (i = 0; i < NTHREADS; i++) {
        ret = pthread_join(tid[i], (void **)&stat);
        if (ret)
            printf("pthread_join() failed! [%d]\n", ret);
    }

    // Destroy the cv attr object and the {mutex,cv} pair..
    pthread_condattr_destroy(&cvattr);
    pthread_mutex_destroy(&mycv_mutex);
    pthread_cond_destroy(&mycv);

    exit(EXIT_SUCCESS);
}