#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <pthread.h>
#include <signal.h>

#define NON_FATAL    0

#define WARN(warnmsg, args...) do {                           \
    handle_err(NON_FATAL, "!WARNING! %s:%s:%d: " warnmsg, \
       __FILE__, __FUNCTION__, __LINE__, ##args);         \
} while(0)

#define HZ  250
#define DELAY_LOOP(val,loop_count)                                             \
{                                                                              \
    int c=0, m;                                                            \
    unsigned int for_index,inner_index;                                    \
                                                                           \
    for(for_index=0;for_index<loop_count;for_index++) {                    \
        beep((val));                                                   \
        c++;                                                           \
        for(inner_index=0;inner_index<HZ*1000;inner_index++)           \
            for(m=0;m<30;m++);                                     \
        }                                                              \
    /*printf("c=%d\n",c);*/                                                \
}

#define NTHREADS    2

/*
 * signal_handler() : our MT app's dedicated 'signal hanler thread'. We
 * handle all signals here.
 */
static void *signal_handler(void *arg) {
    sigset_t sigset;
    int sig;

    printf("Dedicated signal_handler() thread alive..\n");
    while (1) {
        /* Wait for any/all signals */
        if (sigfillset(&sigset) == -1)
            fprintf(stderr, "sigfillset failed");
        if (sigwait(&sigset, &sig) < 0)
            fprintf(stderr, "sigwait failed");

        /* Note on sigwait():
         *    sigwait suspends the calling thread until one of 
         *    (any of) the  signals  in set is delivered to the 
         *    calling thread. It then stores the number of the 
         *    signal received in the location  pointed  to  by  
         *    "sig" and returns.  The  signals  in set must be 
         *    blocked and not ignored on entrance to sigwait. 
         *    If the delivered signal has a  signal handler 
         *    function attached, that function is *not* called.
         */

        /* We've caught a signal! 
         * Here, as a demo, we just emit a simple printf. 
         * In a 'real' app, handle the signal here itself.
         */
        switch (sig) {
        case SIGINT:
            // Perform signal handling for SIGINT here
            printf("+++ signal_handler(): caught signal #%d +++\n",
                   sig);
            break;
        case SIGQUIT:
            // Perform signal handling for SIGQUIT here
            printf("+++ signal_handler(): caught signal #%d +++\n",
                   sig);
            break;
        case SIGIO:
            // Perform signal handling for SIGIO here
            printf("+++ signal_handler(): caught signal #%d +++\n",
                   sig);
            break;
        default:
            // Signal <whichever> caught
            printf
                ("*** signal_handler(): caught signal #%2d [unhandled] ***\n",
                 sig);
            break;
        }
    }
    return (void *)0;
}

static void *work(void *id) {
    long this = (long)id;
    printf(" [Thread #%ld] PID %d running ...\n", this, getpid());
    if (this == 1) {
        DELAY_LOOP('1', 200);
    } else if (this == 2) {
        DELAY_LOOP('2', 200);
    }
    printf("\n---------------------------------------\n");
    pthread_exit((void *)0);
}

int main(void) {
    sigset_t sigset;
    pthread_t pthrd[NTHREADS + 1];
    pthread_attr_t attr;
    long t = 0, stat;
    int ret = 0;

    /* 
     * Block *all* signals here in the main thread.
     * Now all subsequently created threads also block all signals.
     */
    sigfillset(&sigset);
    if (pthread_sigmask(SIG_BLOCK, &sigset, NULL))
        fprintf(stderr, "main: pthread_sigmask failed");

    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);

    /*--- Create the dedicated signal handling thread ---*/
    ret = pthread_create(&pthrd[t], &attr, signal_handler, NULL);
    if (ret)
        fprintf(stderr, "pthread_create %ld failed [%d]\n", t, ret);

    /* Create worker threads */
    for (t = 1; t < NTHREADS + 1; t++) {
        ret = pthread_create(&pthrd[t], &attr, work, (void *)t);
        if (ret)
            fprintf(stderr, "pthread_create %ld failed [%d]\n", t, ret);
    }

    /* Block on signals forever; until we catch a fatal one! */
    while (1)
        (void)pause();

    /* In this demo, this code below is never reached; it's nevertheless
     * there for completeness. */
    // Thread join loop
    for (t = 0; t < NTHREADS; t++) {
        printf("main: joining (waiting) upon thread #%ld ...\n", t);
        ret = pthread_join(pthrd[t], (void **)&stat);
        if (ret)
            WARN("pthread_join() failed! [%d]\n", ret);
        else {
            printf
                ("Thread #%ld successfully joined; it terminated with "
                 "status=%ld\n", t, stat);
            if ((void *)stat == PTHREAD_CANCELED)
                printf("   *** Was CANCELLED ***\n");
        }
    }

    printf("\nmain: now dying... <Dramatic!> Farewell!\n");
    pthread_exit(NULL);
}
